<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
	xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
	xmlns:ccts="urn:un:unece:uncefact:documentation:2"
	xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001"
	xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988"
	xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001"
	xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase"
	xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
	xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
	xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
	xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance"
	xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:lcl="http://www.efatura.gov.tr/local"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi lcl">
	<xsl:character-map name="a"> 
		<xsl:output-character character="&#128;" string=""/>
		<xsl:output-character character="&#129;" string=""/>
		<xsl:output-character character="&#130;" string=""/>
		<xsl:output-character character="&#131;" string=""/>
		<xsl:output-character character="&#132;" string=""/>
		<xsl:output-character character="&#133;" string=""/>
		<xsl:output-character character="&#134;" string=""/>
		<xsl:output-character character="&#135;" string=""/>
		<xsl:output-character character="&#136;" string=""/>
		<xsl:output-character character="&#137;" string=""/>
		<xsl:output-character character="&#138;" string=""/>
		<xsl:output-character character="&#139;" string=""/>
		<xsl:output-character character="&#140;" string=""/>
		<xsl:output-character character="&#141;" string=""/>
		<xsl:output-character character="&#142;" string=""/>
		<xsl:output-character character="&#143;" string=""/>
		<xsl:output-character character="&#144;" string=""/>
		<xsl:output-character character="&#145;" string=""/>
		<xsl:output-character character="&#146;" string=""/>
		<xsl:output-character character="&#147;" string=""/>
		<xsl:output-character character="&#148;" string=""/>
		<xsl:output-character character="&#149;" string=""/>
		<xsl:output-character character="&#150;" string=""/>
		<xsl:output-character character="&#151;" string=""/>
		<xsl:output-character character="&#152;" string=""/>
		<xsl:output-character character="&#153;" string=""/>
		<xsl:output-character character="&#154;" string=""/>
		<xsl:output-character character="&#155;" string=""/>
		<xsl:output-character character="&#156;" string=""/>
		<xsl:output-character character="&#157;" string=""/>
		<xsl:output-character character="&#158;" string=""/>
		<xsl:output-character character="&#159;" string=""/>
	</xsl:character-map>
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="." NaN=""/>
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" use-character-maps="a"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML" select="/"/>	
	
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					body {
					    background-color: #FFFFFF;
					    font-family: 'Tahoma', "Times New Roman", Times, serif;
					    font-size: 11px;
					    color: #666666;
					}
					h1, h2 {
					    padding-bottom: 3px;
					    padding-top: 3px;
					    margin-bottom: 5px;
					    text-transform: uppercase;
					    font-family: Arial, Helvetica, sans-serif;
					}
					h1 {
					    font-size: 1.4em;
					    text-transform:none;
					}
					h2 {
					    font-size: 1em;
					    color: brown;
					}
					h3 {
					    font-size: 1em;
					    color: #333333;
					    text-align: justify;
					    margin: 0;
					    padding: 0;
					}
					h4 {
					    font-size: 1.1em;
					    font-style: bold;
					    font-family: Arial, Helvetica, sans-serif;
					    color: #000000;
					    margin: 0;
					    padding: 0;
					}
					hr {
					    height:2px;
					    color: #000000;
					    background-color: #000000;
					    border-bottom: 1px solid #000000;
					}
					p, ul, ol {
					    margin-top: 1.5em;
					}
					ul, ol {
					    margin-left: 3em;
					}
					blockquote {
					    margin-left: 3em;
					    margin-right: 3em;
					    font-style: italic;
					}
					a {
					    text-decoration: none;
					    color: #70A300;
					}
					a:hover {
					    border: none;
					    color: #70A300;
					}
					#despatchTable {
					    border-collapse:collapse;
					    font-size:11px;
					    float:right;
					    border-color:gray;
					}
					#ettnTable {
					    border-collapse:collapse;
					    font-size:11px;
					    border-color:gray;
					}
					#customerPartyTable {
					    border-width: 0px;
					    border-spacing:;
					    border-style: inset;
					    border-color: gray;
					    border-collapse: collapse;
					    background-color:
					}
					#customerIDTable {
					    border-width: 2px;
					    border-spacing:;
					    border-style: inset;
					    border-color: gray;
					    border-collapse: collapse;
					    background-color:
					}
					#customerIDTableTd {
					    border-width: 2px;
					    border-spacing:;
					    border-style: inset;
					    border-color: gray;
					    border-collapse: collapse;
					    background-color:
					}
					#lineTable {
					    border-width:2px;
					    border-spacing:;
					    border-style: inset;
					    border-color: black;
					    border-collapse: collapse;
					    background-color:;
					}
					td.lineTableTd {
					    border-width: 1px;
					    padding: 1px;
					    border-style: inset;
					    border-color: black;
					    background-color: white;
					}
					tr.lineTableTr {
					    border-width: 1px;
					    padding: 0px;
					    border-style: inset;
					    border-color: black;
					    background-color: white;
					    -moz-border-radius:;
					}
					#lineTableDummyTd {
					    border-width: 1px;
					    border-color:white;
					    padding: 1px;
					    border-style: inset;
					    border-color: black;
					    background-color: white;
					}
					td.lineTableBudgetTd {
					    border-width: 2px;
					    border-spacing:0px;
					    padding: 1px;
					    border-style: inset;
					    border-color: black;
					    background-color: white;
					    -moz-border-radius:;
					}
					#notesTable {
					    border-width: 2px;
					    border-spacing:;
					    border-style: inset;
					    border-color: black;
					    border-collapse: collapse;
					    background-color:
					}
					#notesTableTd {
					    border-width: 0px;
					    border-spacing:;
					    border-style: inset;
					    border-color: black;
					    border-collapse: collapse;
					    background-color:
					}
					table {
					    border-spacing:0px;
					}
					#budgetContainerTable {
					    border-width: 0px;
					    border-spacing: 0px;
					    border-style: inset;
					    border-color: black;
					    border-collapse: collapse;
					    background-color:;
					}
					td {
					    border-color:gray;
					}</style>
				<title>e-Fatura</title>
			</head>
			<body
				style="margin-left=0.6in; margin-right=0.6in; margin-top=0.79in; margin-bottom=0.79in">
				<xsl:for-each select="$XML">
					<table style="border-color:blue; " border="0" cellspacing="0px" width="800"
						cellpadding="0px">
						<tbody>
							<tr valign="top">
								<td width="40%">
									<br/>
									<hr/>
									<table align="center" border="0" width="100%">
										<tbody>
											<tr align="left">
												<xsl:for-each select="n1:Invoice/cac:AccountingSupplierParty/cac:Party">
													<td align="left">
													<xsl:if test="cac:PartyName">
													<xsl:value-of select="cac:PartyName/cbc:Name"/>
													<br/>
													</xsl:if>
													<xsl:for-each select="cac:Person">
														<xsl:for-each select="cbc:Title">
														<xsl:apply-templates/>
														<xsl:text>&#160;</xsl:text>
														</xsl:for-each>
														<xsl:for-each select="cbc:FirstName">
														<xsl:apply-templates/>
														<xsl:text>&#160;</xsl:text>
														</xsl:for-each>
														<xsl:for-each select="cbc:MiddleName">
														<xsl:apply-templates/>
														<xsl:text>&#160;</xsl:text>
														</xsl:for-each>
														<xsl:for-each select="cbc:FamilyName">
														<xsl:apply-templates/>
														<xsl:text>&#160;</xsl:text>
														</xsl:for-each>
														<xsl:for-each select="cbc:NameSuffix">
														<xsl:apply-templates/>
														</xsl:for-each>
													</xsl:for-each>
													</td>
												</xsl:for-each>
											</tr>
											<tr align="left">
												<xsl:for-each select="n1:Invoice/cac:AccountingSupplierParty/cac:Party">
												<td align="left">
												<xsl:for-each select="cac:PostalAddress">
													<xsl:for-each select="cbc:StreetName">
													<xsl:apply-templates/>
													<xsl:text>&#160;</xsl:text>
													</xsl:for-each>
													<xsl:for-each select="cbc:BuildingName">
													<xsl:apply-templates/>
													</xsl:for-each>
													<xsl:if test="cbc:BuildingNumber">
													<xsl:text> No:</xsl:text>
													<xsl:for-each select="cbc:BuildingNumber">
													<xsl:apply-templates/>
													</xsl:for-each>
													<xsl:text>&#160;</xsl:text>
													</xsl:if>
													<br/>
													<xsl:for-each select="cbc:PostalZone">
													<xsl:apply-templates/>
													<xsl:text>&#160;</xsl:text>
													</xsl:for-each>
													<xsl:for-each select="cbc:CitySubdivisionName">
													<xsl:apply-templates/>
													</xsl:for-each>
													<xsl:text>/ </xsl:text>
													<xsl:for-each select="cbc:CityName">
													<xsl:apply-templates/>
													<xsl:text>&#160;</xsl:text>
													</xsl:for-each>
												</xsl:for-each>
												</td>
												</xsl:for-each>
											</tr>
											<xsl:if
												test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telephone or //n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telefax">
												<tr align="left">
													<xsl:for-each select="n1:Invoice/cac:AccountingSupplierParty/cac:Party">														
														<td align="left">
														<xsl:for-each select="cac:Contact">
														<xsl:if test="cbc:Telephone">
														<xsl:text>Tel: </xsl:text>
														<xsl:for-each select="cbc:Telephone">
														<xsl:apply-templates/>
														</xsl:for-each>
														</xsl:if>
														<xsl:if test="cbc:Telefax">
														<xsl:text> Fax: </xsl:text>
														<xsl:for-each select="cbc:Telefax">
														<xsl:apply-templates/>
														</xsl:for-each>
														</xsl:if>
														<xsl:text>&#160;</xsl:text>
														</xsl:for-each>
														</td>
													</xsl:for-each>
												</tr>
											</xsl:if>
											<xsl:for-each
												select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI">
												<tr align="left">
												<td>
												<xsl:text>Web Sitesi: </xsl:text>
												<xsl:value-of select="."/>
												</td>
												</tr>
											</xsl:for-each>
											<xsl:for-each
												select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail">
												<tr align="left">
												<td>
												<xsl:text>E-Posta: </xsl:text>
												<xsl:value-of select="."/>
												</td>
												</tr>
											</xsl:for-each>
											<tr align="left">
												<xsl:for-each select="n1:Invoice/cac:AccountingSupplierParty/cac:Party">																											
													<td align="left">
													<xsl:text>Vergi Dairesi: </xsl:text>
													<xsl:for-each select="cac:PartyTaxScheme">
													<xsl:for-each select="cac:TaxScheme">
													<xsl:for-each select="cbc:Name">
													<xsl:apply-templates/>
													</xsl:for-each>
													</xsl:for-each>
													<xsl:text>&#160; </xsl:text>
													</xsl:for-each>
													</td>
												</xsl:for-each>
											</tr>
											<xsl:for-each
												select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification">
												<tr align="left">
												<td>
												<xsl:value-of select="cbc:ID/@schemeID"/>
												<xsl:text>: </xsl:text>
												<xsl:value-of select="cbc:ID"/>
												</td>
												</tr>
											</xsl:for-each>
										</tbody>
									</table>
									<hr/>
								</td>
								<td width="20%" align="center" valign="middle">
									<br/>
									<br/>
									<img style="width:91px;" align="middle" alt="E-Fatura Logo"
										src="data:image/jpeg;base64,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"/>

									<h1 align="center">
										<span style="font-weight:bold; ">
											<xsl:text>e-FATURA</xsl:text>
										</span>
									</h1>
								</td>
								<td width="40%" style="text-align:right; vertical-align:middle"> <!-- VEYA <td width="50%" style="padding-left:145px; vertical-align:middle"> -->
<img style="height:60px;width:250px;" 
src="data:image/jpeg;base64,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"/>
<!-- src"ÇİFT TIRNAK ARASINA LOGO BASE64 KODU GİRİLİR" --></td>
							</tr>
							<tr style="height:118px; " valign="top">
								<td width="40%" align="right" valign="bottom">
									<table id="customerPartyTable" align="left" border="0">
										<tbody>
											<tr style="height:71px; ">
												<td>
												<hr/>
												<table align="center" border="0">
												<tbody>
												<tr>
												<xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
													<td style="width:469px; " align="left">
														<span style="font-weight:bold; ">
															<xsl:text>SAYIN</xsl:text>
														</span>
													</td>
												</xsl:for-each>													
												</tr>
												<tr>
													<xsl:choose>
														<xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
															<xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
																<xsl:call-template name="Party_Title">
																	<xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
																</xsl:call-template>
															</xsl:for-each>															
														</xsl:when>
														<xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='EXPORT']">
															<xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
																<xsl:call-template name="Party_Title">
																	<xsl:with-param name="PartyType">EXPORT</xsl:with-param>
																</xsl:call-template>
															</xsl:for-each>															
														</xsl:when>
														<xsl:otherwise>
															<xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
																<xsl:call-template name="Party_Title">
																	<xsl:with-param name="PartyType">OTHER</xsl:with-param>
																</xsl:call-template>
															</xsl:for-each>															
														</xsl:otherwise>
													</xsl:choose>													
												</tr>
													<xsl:choose>
														<xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
																<xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
																	<tr>
																		<xsl:call-template name="Party_Adress">
																			<xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
																		</xsl:call-template>
																	</tr>
																	<xsl:call-template name="Party_Other">
																		<xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
																	</xsl:call-template>
																</xsl:for-each>															
														</xsl:when>
														<xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='EXPORT']">
															<xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
																<tr>
																	<xsl:call-template name="Party_Adress">
																		<xsl:with-param name="PartyType">EXPORT</xsl:with-param>
																	</xsl:call-template>
																</tr>
																<xsl:call-template name="Party_Other">
																	<xsl:with-param name="PartyType">EXPORT</xsl:with-param>
																</xsl:call-template>
															</xsl:for-each>															
														</xsl:when>
														<xsl:otherwise>
															<xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
																<tr>
																	<xsl:call-template name="Party_Adress">
																		<xsl:with-param name="PartyType">OTHER</xsl:with-param>																	
																	</xsl:call-template>
																</tr>
																<xsl:call-template name="Party_Other">
																	<xsl:with-param name="PartyType">OTHER</xsl:with-param>
																</xsl:call-template>
															</xsl:for-each>
														</xsl:otherwise>
													</xsl:choose>																										
												</tbody>
												</table>
												<hr/>
												</td>
											</tr>
										</tbody>
									</table>
									<br/>
								</td>
								<td width="60%" align="center" valign="bottom" colspan="2">
									<table border="1" id="despatchTable">
										<tbody>
											<tr>
												<td style="width:105px;" align="left">
												<span style="font-weight:bold; ">
												<xsl:text>Özelleştirme No:</xsl:text>
												</span>
												</td>
												<td style="width:110px;" align="left">
													<xsl:for-each select="n1:Invoice/cbc:CustomizationID">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px; ">
												<td align="left">
												<span style="font-weight:bold; ">
												<xsl:text>Senaryo:</xsl:text>
												</span>
												</td>
												<td align="left">
													<xsl:for-each select="n1:Invoice/cbc:ProfileID">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px; ">
												<td align="left">
												<span style="font-weight:bold; ">
												<xsl:text>Fatura Tipi:</xsl:text>
												</span>
												</td>
												<td align="left">
													<xsl:for-each select="n1:Invoice/cbc:InvoiceTypeCode">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px; ">
												<td align="left">
												<span style="font-weight:bold; ">
												<xsl:text>Fatura No:</xsl:text>
												</span>
												</td>
												<td align="left">
													<xsl:for-each select="n1:Invoice/cbc:ID">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px; ">
												<td align="left">
												<span style="font-weight:bold; ">
												<xsl:text>Fatura Tarihi:</xsl:text>
												</span>
												</td>
												<td align="left">
													<xsl:for-each select="n1:Invoice/cbc:IssueDate">
														<xsl:apply-templates select="."/>
													</xsl:for-each>
												</td>
											</tr>
											<xsl:for-each select="n1:Invoice/cac:DespatchDocumentReference">
												<tr style="height:13px; ">
													<td align="left">
														<span style="font-weight:bold; ">
															<xsl:text>İrsaliye No:</xsl:text>
														</span>
														<xsl:text>&#160;</xsl:text>
													</td>
													<td align="left">
														<xsl:value-of select="cbc:ID"/>
													</td>
												</tr>
												<tr style="height:13px; ">
													<td align="left">
														<span style="font-weight:bold; ">
															<xsl:text>İrsaliye Tarihi:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="cbc:IssueDate">
															<xsl:apply-templates select="."/>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:for-each>
											<xsl:if test="//n1:Invoice/cac:OrderReference">
												<tr style="height:13px">
													<td align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Sipariş No:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="n1:Invoice/cac:OrderReference/cbc:ID">
															<xsl:apply-templates/>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
											<xsl:if	test="//n1:Invoice/cac:OrderReference/cbc:IssueDate">
												<tr style="height:13px">
													<td align="left">
														<span style="font-weight:bold; ">
														<xsl:text>Sipariş Tarihi:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="n1:Invoice/cac:OrderReference/cbc:IssueDate">
															<xsl:apply-templates select="."/>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
											<xsl:for-each select="n1:Invoice/cac:TaxRepresentativeParty/cac:PartyIdentification/cbc:ID[@schemeID='ARACIKURUMVKN']"> 
												<tr>
													<td style="width:105px;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Aracı Kurum VKN:</xsl:text>
														</span>
													</td>
													<td style="width:110px;" align="left">
														<xsl:value-of select="."/>
													</td>
												</tr>
												<tr>
													<td style="width:105px;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Aracı Kurum Unvan:</xsl:text>
														</span>
													</td>
													<td style="width:110px;" align="left">
														<xsl:value-of select="../../cac:PartyName/cbc:Name"/>
													</td>
												</tr>
											</xsl:for-each>											
										</tbody>
									</table>
								</td>
							</tr>
							<tr align="left">
								<td align="left" valign="top" id="ettnTable">
									<span style="font-weight:bold; ">
										<xsl:text>ETTN:&#160;</xsl:text>
									</span>
									<xsl:for-each select="n1:Invoice/cbc:UUID">
										<xsl:apply-templates/>
									</xsl:for-each>
								</td>
							</tr>
						</tbody>
					</table>
					<div id="lineTableAligner">
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
					<table border="1" id="lineTable" width="800">
						<tbody>
							<tr class="lineTableTr">
								<td class="lineTableTd" style="width:3%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Sıra No</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:20%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Mal Hizmet</xsl:text>
									</span>
								</td>
								<td id="lineTableTd" style="width:10%" align="center">
									<span style="font-weight:bold; ">
										<xsl:text>Malzeme/Hizmet Açıklaması</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:7.4%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Miktar</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:9%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Birim Fiyat</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:7%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>İskonto Oranı</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:9%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>İskonto Tutarı</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:7%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>KDV Oranı</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:10%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>KDV Tutarı</xsl:text>
									</span>
								</td>
								<td class="lineTableTd" style="width:10.6%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Mal Hizmet Tutarı</xsl:text>
									</span>
								</td>
								<xsl:if test="//n1:Invoice/cbc:ProfileID='IHRACAT'">
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Teslim Şartı</xsl:text>
										</span>
									</td>									
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Eşya Kap Cinsi</xsl:text>
										</span>
									</td>									
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Kap No</xsl:text>
										</span>
									</td>									
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Kap Adet</xsl:text>
										</span>
									</td>									
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Teslim/Bedel Ödeme Yeri</xsl:text>
										</span>
									</td>									
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Gönderilme Şekli</xsl:text>
										</span>
									</td>									
									<td class="lineTableTd" style="width:10.6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>GTİP</xsl:text>
										</span>
									</td>									
								</xsl:if>
							</tr>
							<xsl:if test="count(//n1:Invoice/cac:InvoiceLine) &gt;= 1">
								<xsl:for-each select="//n1:Invoice/cac:InvoiceLine">
									<xsl:apply-templates select="."/>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="count(//n1:Invoice/cac:InvoiceLine) &lt; 1">
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[1]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[1]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[2]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[2]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[3]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[3]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[4]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[4]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[5]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[5]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[6]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[6]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[7]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[7]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[8]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[8]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[9]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[9]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[10]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[10]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[11]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[11]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[12]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[12]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[13]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[13]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[14]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[14]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[15]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[15]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[16]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[16]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[17]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[17]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[18]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[18]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[19]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[19]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="//n1:Invoice/cac:InvoiceLine[20]">
										<xsl:apply-templates
											select="//n1:Invoice/cac:InvoiceLine[20]"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						</tbody>
					</table>
				</xsl:for-each>
				<table id="budgetContainerTable" width="800px">
					<tr align="right">
						<td/>
						<td class="lineTableBudgetTd" align="right" width="200px">
							<span style="font-weight:bold; ">
								<xsl:text>Mal Hizmet Toplam Tutarı</xsl:text>
							</span>
						</td>
						<td class="lineTableBudgetTd" style="width:81px; " align="right">
							<xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount">
								<xsl:call-template name="Curr_Type"/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
						<xsl:if test="cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '4171'">
							<tr align="right">
								<td/>
								<td class="lineTableBudgetTd" align="right" width="200px">
									<span style="font-weight:bold; ">
										<xsl:text>Teslim Bedeli</xsl:text>
									</span>
								</td>
								<td class="lineTableBudgetTd" style="width:81px; " align="right">
									<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount">
										<xsl:call-template name="Curr_Type"/>
									</xsl:for-each>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
					
					<xsl:for-each select="n1:Invoice/cac:AllowanceCharge">
						<xsl:if	test="cbc:ChargeIndicator = 'true' ">
							<tr align="right">
								<td/>
								<td class="lineTableBudgetTd" style="width:102px; " align="right">
									<span style="font-weight:bold; ">
									<xsl:value-of select="cbc:AllowanceChargeReason"/>
									</span>
								</td>
								<td class="lineTableBudgetTd" style="width:102px; " align="right">
									<xsl:for-each select="cbc:Amount">
									<xsl:call-template name="Curr_Type"/>
									</xsl:for-each>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>	
					
					<tr align="right">
						<td/>
						<td class="lineTableBudgetTd" align="right" width="200px">
							<span style="font-weight:bold; ">
								<xsl:text>Toplam İskonto</xsl:text>
							</span>
						</td>
						<td class="lineTableBudgetTd" style="width:81px; " align="right">
							<xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount">
								<xsl:call-template name="Curr_Type"/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="211px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Hesaplanan </xsl:text>
									<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
									<xsl:if test="../../cbc:InvoiceTypeCode!='OZELMATRAH'">
										<xsl:text>(</xsl:text>
										<xsl:choose>
											<xsl:when test="//n1:Invoice/cac:PricingExchangeRate/cbc:SourceCurrencyCode = 'TRY' and //n1:Invoice/cac:PricingExchangeRate/cbc:TargetCurrencyCode != 'TRY'">
												<xsl:value-of select="format-number(cbc:TaxableAmount div //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="format-number(cbc:TaxableAmount, '###.##0,00', 'european')"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text> %</xsl:text>
										<xsl:value-of select="cbc:Percent"/>
										<xsl:text>)</xsl:text>
									</xsl:if>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:if test="../../cbc:InvoiceTypeCode='OZELMATRAH'">
									<xsl:text> </xsl:text>
									<xsl:text>DAHİLDİR</xsl:text>
								</xsl:if>
								<xsl:if test="../../cbc:InvoiceTypeCode!='OZELMATRAH'">
									<xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
										<xsl:text> </xsl:text>
										<xsl:value-of
											select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
										<xsl:if test="../../cbc:TaxAmount/@currencyID">
											<xsl:text> </xsl:text>
											<xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRL' or ../../cbc:TaxAmount/@currencyID = 'TRY'">
												<xsl:text>TL</xsl:text>
											</xsl:if>
											<xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRL' and ../../cbc:TaxAmount/@currencyID != 'TRY'">
												<xsl:value-of select="../../cbc:TaxAmount/@currencyID"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</xsl:if>
							</td>
						</tr>
					</xsl:for-each>
					<xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
						<xsl:if test="cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '4171'">
							<tr align="right">
								<td/>
								<td class="lineTableBudgetTd" align="right" width="200px">
									<span style="font-weight:bold; ">
										<xsl:text>KDV Matrahı</xsl:text>
									</span>
								</td>
								<td class="lineTableBudgetTd" style="width:81px; " align="right">
									<xsl:value-of
											select="format-number(sum(//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=0015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>										
									<xsl:if
										test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID">
										<xsl:text> </xsl:text>
										<xsl:if
											test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID = 'TRL' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID = 'TRY'">
											<xsl:text>TL</xsl:text>
										</xsl:if>
										<xsl:if
											test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID != 'TRL' and //n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID != 'TRY'">
											<xsl:value-of
												select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID"
											/>
										</xsl:if>
									</xsl:if>
								</td>
							</tr>
							<tr align="right">
								<td/>
								<td class="lineTableBudgetTd" align="right" width="200px">
									<span style="font-weight:bold; ">
										<xsl:text>Tevkifat Dahil Toplam Tutar</xsl:text>
									</span>
								</td>
								<td class="lineTableBudgetTd" style="width:81px; " align="right">
									<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount">
										<xsl:call-template name="Curr_Type"/>
									</xsl:for-each>
								</td>
							</tr>
							<tr align="right">
								<td/>
								<td class="lineTableBudgetTd" align="right" width="200px">
									<span style="font-weight:bold; ">
										<xsl:text>Tevkifat Hariç Toplam Tutar</xsl:text>
									</span>
								</td>
								<td class="lineTableBudgetTd" style="width:81px; " align="right">
									<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
										<xsl:call-template name="Curr_Type"/>
									</xsl:for-each>
								</td>
							</tr>
						</xsl:if>						
					</xsl:for-each>
					<xsl:for-each select="n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal">
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="211px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Hesaplanan KDV Tevkifat</xsl:text>
									<xsl:text>(%</xsl:text>
									<xsl:value-of select="cbc:Percent"/>
									<xsl:text>)</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
									<xsl:text> </xsl:text>
									<xsl:value-of
										select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
									<xsl:if test="../../cbc:TaxAmount/@currencyID">
										<xsl:text> </xsl:text>
										<xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRL' or ../../cbc:TaxAmount/@currencyID = 'TRY'">
											<xsl:text>TL</xsl:text>
										</xsl:if>
										<xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRL' and ../../cbc:TaxAmount/@currencyID != 'TRY'">
											<xsl:value-of select="../../cbc:TaxAmount/@currencyID"/>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:for-each>
					<xsl:if
						test="sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount)>0">
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="211px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Tevkifata Tabi İşlem Tutarı</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:value-of
									select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL'">
									<xsl:text>TL</xsl:text>
								</xsl:if>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL'">
									<xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
								</xsl:if>
							</td>
						</tr>
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="211px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Tevkifata Tabi İşlem Üzerinden Hes. KDV</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:value-of
									select="format-number(sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL'">
									<xsl:text>TL</xsl:text>
								</xsl:if>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL'">
									<xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
								</xsl:if>
							</td>
						</tr>
					</xsl:if>					
					<xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="211px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Tevkifata Tabi İşlem Tutarı</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
									<xsl:value-of
										select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
								</xsl:if>
								<xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
									<xsl:value-of
										select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
								</xsl:if>								
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL' or n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
									<xsl:text>TL</xsl:text>
								</xsl:if>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL' and n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
									<xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
								</xsl:if>
							</td>
						</tr>
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="211px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Tevkifata Tabi İşlem Üzerinden Hes. KDV</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
									<xsl:value-of
										select="format-number(sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
								</xsl:if>
								<xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
									<xsl:value-of
										select="format-number(sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
								</xsl:if>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL' or n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
									<xsl:text>TL</xsl:text>
								</xsl:if>
								<xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL' and n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
									<xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
								</xsl:if>
							</td>
						</tr>
					</xsl:if>
					<tr align="right">
						<td/>
						<td class="lineTableBudgetTd" width="200px" align="right">
							<span style="font-weight:bold; ">
								<xsl:text>Vergiler Dahil Toplam Tutar</xsl:text>
							</span>
						</td>
						<td class="lineTableBudgetTd" style="width:82px; " align="right">
							<xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount">
								<xsl:call-template name="Curr_Type"/>
							</xsl:for-each>
						</td>
					</tr>
					<tr align="right">
						<td/>
						<td class="lineTableBudgetTd" width="200px" align="right">
							<span style="font-weight:bold; ">
								<xsl:text>Ödenecek Tutar</xsl:text>
							</span>
						</td>
						<td class="lineTableBudgetTd" style="width:82px; " align="right">
							<xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
								<xsl:call-template name="Curr_Type"/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
						<xsl:if	test="//n1:Invoice/cbc:DocumentCurrencyCode != 'TRY' and //n1:Invoice/cbc:DocumentCurrencyCode != 'TRL'">
							<tr align="right">
								<td/>
								<td class="lineTableBudgetTd" align="right" width="200px">
									<span style="font-weight:bold; ">
										<xsl:text>Hesaplanan </xsl:text>
										<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
										<xsl:text>(%</xsl:text>
										<xsl:value-of select="cbc:Percent"/>
										<xsl:text>) (TL)</xsl:text>
									</span>
								</td>
								<td class="lineTableBudgetTd" style="width:81px; " align="right">
									<span>
										<xsl:value-of
											select="format-number(cbc:TaxAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
										<xsl:text> TL</xsl:text>
									</span>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>					
					<xsl:if
						test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRL' and //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" align="right" width="200px">
								<span style="font-weight:bold; ">
									<xsl:text>Mal Hizmet Toplam Tutarı(TL)</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:81px; " align="right">
								<xsl:value-of
									select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
								<xsl:text> TL</xsl:text>
							</td>
						</tr>
						
					<xsl:if
						test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRL' and //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY' ">
							<xsl:for-each select="n1:Invoice/cac:AllowanceCharge">
							<xsl:if	test="cbc:ChargeIndicator = 'true' ">
								<tr align="right">
									<td/>
									<td class="lineTableBudgetTd" style="width:102px; " align="right">
										<span style="font-weight:bold; ">
										<xsl:value-of select="cbc:AllowanceChargeReason"/>
										<xsl:text>(TL)</xsl:text>
										</span>
									</td>
									<td class="lineTableBudgetTd" style="width:102px; " align="right">
										<xsl:value-of
										select="format-number(cbc:Amount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
										<xsl:text> TL</xsl:text>
										
									</td>
								</tr>
							</xsl:if>	
							</xsl:for-each>
					</xsl:if>
						
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="200px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Vergiler Dahil Toplam Tutar(TL)</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:value-of
									select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
								<xsl:text> TL</xsl:text>
							</td>
						</tr>
						<tr align="right">
							<td/>
							<td class="lineTableBudgetTd" width="200px" align="right">
								<span style="font-weight:bold; ">
									<xsl:text>Ödenecek Tutar(TL)</xsl:text>
								</span>
							</td>
							<td class="lineTableBudgetTd" style="width:82px; " align="right">
								<xsl:value-of
									select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
								<xsl:text> TL</xsl:text>
							</td>
						</tr>
					</xsl:if>
				</table>
				<br/>
				<xsl:if test="//n1:Invoice/cac:BillingReference/cac:InvoiceDocumentReference/cbc:DocumentTypeCode[text()='İADE' or text()='IADE']">
					<table id="lineTable" width="800">
						<thead>
							<tr>
								<td align="left"><span style="font-weight:bold; " align="center">&#160;&#160;&#160;&#160;&#160;İadeye Konu Olan Faturalar</span></td>							
							</tr>
						</thead>					
						<tbody>
							<tr align="left" class="lineTableTr">							
								<td class="lineTableTd">
									<span style="font-weight:bold; " align="center">&#160;&#160;&#160;&#160;&#160;Fatura No</span>
								</td>
								<td class="lineTableTd"><span style="font-weight:bold; " align="center">&#160;&#160;&#160;&#160;&#160;Tarih</span></td>
							</tr>
							<xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:InvoiceDocumentReference/cbc:DocumentTypeCode[text()='İADE' or text()='IADE']">
								<tr align="left" class="lineTableTr">
									<td class="lineTableTd">&#160;&#160;&#160;&#160;&#160;
										<xsl:value-of select="../cbc:ID"/> 
									</td>
									<td class="lineTableTd">&#160;&#160;&#160;&#160;&#160;
										<xsl:for-each select="../cbc:IssueDate">
											<xsl:apply-templates select="."/>
										</xsl:for-each> 
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<br/>
				<!--<xsl:if	test="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference/cbc:DocumentTypeCode='OKCBF'">
					<table border="1" id="lineTable" width="800">
						<thead>
							<tr>
								<th colspan="6">ÖKC Bilgileri</th>
							</tr>
						</thead>							
						<tbody>
							<tr id="okcbfHeadTr" style="font-weight:bold;">
								<td style="width:20%">
									<xsl:text>Fiş Numarası</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>Fiş Tarihi</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>Fiş Saati</xsl:text>
								</td>
								<td style="width:40%" align="center">
									<xsl:text>Fiş Tipi</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>Z Rapor No</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>ÖKC Seri No</xsl:text>
								</td>
							</tr>						
						</tbody>
						<xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference/cbc:DocumentTypeCode[text()='OKCBF']">
							<tr>
								<td style="width:20%">
									<xsl:value-of select="../cbc:ID"/>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="../cbc:IssueDate"/>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="substring(../cac:ValidityPeriod/cbc:StartTime,1,5)"/>
								</td>
								<td style="width:40%" align="center">
									<xsl:choose>
										<xsl:when test="../cbc:DocumentDescription='AVANS'">
											<xsl:text>Ön Tahsilat(Avans) Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='YEMEK_FIS'">
											<xsl:text>Yemek Fişi/Kartı ile Yapılan Tahsilat Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-FATURA'">
											<xsl:text>E-Fatura Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-FATURA_IRSALIYE'">
											<xsl:text>İrsaliye Yerine Geçen E-Fatura Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-ARSIV'">
											<xsl:text>E-Arşiv Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-ARSIV_IRSALIYE'">
											<xsl:text>İrsaliye Yerine Geçen E-Arşiv Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='FATURA'">
											<xsl:text>Faturalı Satış Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='OTOPARK'">
											<xsl:text>Otopark Giriş Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='FATURA_TAHSILAT'">
											<xsl:text>Fatura Tahsilat Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='FATURA_TAHSILAT_KOMISYONLU'">
											<xsl:text>Komisyonlu Fatura Tahsilat Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text> </xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="../cac:Attachment/cac:ExternalReference/cbc:URI"/>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="../cac:IssuerParty/cbc:EndpointID"/>
								</td>
							</tr>													
						</xsl:for-each>
					</table>
					<br/>
				</xsl:if>	-->				
				<table id="notesTable" width="800" align="left">
					<tbody>
						<tr align="left">
							<td id="notesTableTd" height="100">
								<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
									<xsl:if	test="(cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode='0015' or ../../cbc:InvoiceTypeCode='OZELMATRAH') and cac:TaxCategory/cbc:TaxExemptionReason">									
										<b>&#160;&#160;&#160;&#160;&#160; Vergi İstisna Muafiyet Sebebi: </b>
										<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReasonCode"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
										<br/>
									</xsl:if>
									<xsl:if	test="starts-with(cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode,'007') and cac:TaxCategory/cbc:TaxExemptionReason">									
										<b>&#160;&#160;&#160;&#160;&#160; ÖTV İstisna Muafiyet Sebebi: </b>
										<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReasonCode"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
										<br/>
									</xsl:if>
								</xsl:for-each>
								<xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
									<b>&#160;&#160;&#160;&#160;&#160; Tevkifat Sebebi: </b>
									<xsl:value-of select="cbc:TaxTypeCode"/>
									<xsl:text>-</xsl:text>
									<xsl:value-of select="cbc:Name"/>
									<br/>
								</xsl:for-each>
								<xsl:for-each select="//n1:Invoice/cbc:Note">
									<b>&#160;&#160;&#160;&#160;&#160; Not: </b>
									<xsl:value-of select="."/>	
									<br/>
								</xsl:for-each>									
								<xsl:if test="//n1:Invoice/cac:PaymentMeans/cbc:InstructionNote">
									<b>&#160;&#160;&#160;&#160;&#160; Ödeme Notu: </b>
									<xsl:value-of
										select="//n1:Invoice/cac:PaymentMeans/cbc:InstructionNote"/>
									<br/>
								</xsl:if>
								<xsl:if
									test="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote">
									<b>&#160;&#160;&#160;&#160;&#160; Hesap Açıklaması: </b>
									<xsl:value-of
										select="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote"/>
									<br/>
								</xsl:if>
								<xsl:if test="//n1:Invoice/cac:PaymentTerms/cbc:Note">
									<b>&#160;&#160;&#160;&#160;&#160; Ödeme Koşulu: </b>
									<xsl:value-of select="//n1:Invoice/cac:PaymentTerms/cbc:Note"/>
									<br/>
								</xsl:if>
								<xsl:if test="//n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE']='TAXFREE' and //n1:Invoice/cac:TaxRepresentativeParty/cac:PartyTaxScheme/cbc:ExemptionReasonCode">
									<br/>
									<b>&#160;&#160;&#160;&#160;&#160; VAT OFF - NO CASH REFUND </b>
								</xsl:if>
								<xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference">
									<xsl:if test="cbc:DocumentTypeCode = 'OKCBF'">
											<b>&#160;&#160;&#160;&#160;&#160; Yeni Nesil OKC Bilgileri </b> 
											[
											#Cihaz Seri No : <xsl:value-of select="cac:IssuerParty/cbc:EndpointID"/>
											#Tarih :<xsl:for-each select="cac:ValidityPeriod/cbc:StartDate">
														<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
													</xsl:for-each>
													- <xsl:value-of select="cac:ValidityPeriod/cbc:StartTime"/>
											#ZNo : <xsl:value-of select="cac:Attachment/cac:ExternalReference/cbc:URI"/>
											#Bilgi Fişi No: <xsl:value-of select="cbc:ID"/>
											]
									</xsl:if>
								</xsl:for-each>
								<!-- BANKA BİLGİSİ  -->
<table id="hesapBilgileri" width="800px"><tbody><tr><td><fieldset style="border:1px solid black;">
<legend align="center" style="background-color:white; border-width:10px;"><b>KİREMİTCİ ELEKTRİK LTD. ŞTİ. | BANKA HESAP BİLGİLERİ</b> </legend>
<table width="100%" border="0"><tr><td style="font-weight:bold;">BANKA </td> <td style="font-weight:bold;">IBAN </td> </tr>
<tr><td>ZİRAAT BANKASI | 505-ÇİFTELER/ESKİŞEHİR ŞB.</td><td>TR90 0001 0005 0581 7944 0150 02 /TRY-TÜRK LİRASI</td></tr>
<tr><td>QNBFİNANS BANK | 00260-ESKİŞEHİR ŞB.</td><td>TR40 0011 1000 0000 0104 3978 81 /TRY-TÜRK LİRASI</td></tr>

<!--<tr><td>BESINCI BANKA ADI</td><td>TR05 5555 5555</td></tr>-->
</table></fieldset></td></tr></tbody></table>


                                 <!--|*BANKA BİLGİSİ SON*|-->
							</td>
						</tr>
					</tbody>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="//n1:Invoice/cac:InvoiceLine">
		<tr class="lineTableTr">
			<td class="lineTableTd">
				<xsl:text>&#160;</xsl:text>
				<xsl:value-of select="./cbc:ID"/>
			</td>
			<td class="lineTableTd">
				<xsl:text>&#160;</xsl:text>
				<xsl:value-of select="./cac:Item/cbc:Name"/>
			</td>
			<td id="lineTableTd">
					<xsl:for-each select="./cbc:Note">
				<span>
					<xsl:text>&#160;</xsl:text>
					<xsl:value-of select="."/>
		                </span>
						<br/>
					</xsl:for-each>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:value-of
					select="format-number(./cbc:InvoicedQuantity, '###.###,####', 'european')"/>
				<xsl:if test="./cbc:InvoicedQuantity/@unitCode">
					<xsl:for-each select="./cbc:InvoicedQuantity">
						<xsl:text> </xsl:text>
						<xsl:choose>
							<xsl:when test="@unitCode  = 'TNE'">
								<xsl:text>ton</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BX'">
								<xsl:text>Kutu</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'LTR'">
								<xsl:text>lt</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'C62'">
								<xsl:text>Adet</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KGM'">
								<xsl:text>kg</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KJO'">
								<xsl:text>kJ</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GRM'">
								<xsl:text>g</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MGM'">
								<xsl:text>mg</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'NT'">
								<xsl:text>Net Ton</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GT'">
								<xsl:text>Gross Ton</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MTR'">
								<xsl:text>m</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MMT'">
								<xsl:text>mm</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KTM'">
								<xsl:text>km</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MLT'">
								<xsl:text>ml</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MMQ'">
								<xsl:text>mm3</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CLT'">
								<xsl:text>cl</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CMK'">
								<xsl:text>cm2</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CMQ'">
								<xsl:text>cm3</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CMT'">
								<xsl:text>cm</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MTK'">
								<xsl:text>m2</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MTQ'">
								<xsl:text>m3</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DAY'">
								<xsl:text> Gün</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MON'">
								<xsl:text> Ay</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PA'">
								<xsl:text> Paket</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KWH'">
								<xsl:text> KWH</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'ANN'">
								<xsl:text> Yıl</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'HUR'">
								<xsl:text> Saat</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D61'">
								<xsl:text> Dakika</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D62'">
								<xsl:text> Saniye</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CCT'">
								<xsl:text> Ton baş.taşıma kap.</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D30'">
								<xsl:text> Brüt kalori</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D40'">
								<xsl:text> 1000 lt</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'LPA'">
								<xsl:text> saf alkol lt</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'B32'">
								<xsl:text> kg.m2</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'NCL'">
								<xsl:text> hücre adet</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PR'">
								<xsl:text> Çift</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'R9'">
								<xsl:text> 1000 m3</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'SET'">
								<xsl:text> Set</xsl:text>
							</xsl:when>
							<xsl:when test="@unitCode  = 'T3'">
								<xsl:text> 1000 adet</xsl:text>
							</xsl:when>							
						</xsl:choose>
					</xsl:for-each>
				</xsl:if>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:value-of
					select="format-number(./cac:Price/cbc:PriceAmount, '###.##0,########', 'european')"/>
				<xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID">
					<xsl:text> </xsl:text>
					<xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID = &quot;TRL&quot; or ./cac:Price/cbc:PriceAmount/@currencyID = &quot;TRY&quot;">
						<xsl:text>TL</xsl:text>
					</xsl:if>
					<xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID != &quot;TRL&quot; and ./cac:Price/cbc:PriceAmount/@currencyID != &quot;TRY&quot;">
						<xsl:value-of select="./cac:Price/cbc:PriceAmount/@currencyID"/>
					</xsl:if>
				</xsl:if>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:for-each select="./cac:AllowanceCharge/cbc:MultiplierFactorNumeric">
					<xsl:text> %</xsl:text>
					<xsl:value-of select="format-number(. * 100, '###.##0,00', 'european')"/>
				</xsl:for-each>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:for-each select="cac:AllowanceCharge/cbc:Amount">
					<xsl:call-template name="Curr_Type"/>
				</xsl:for-each>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
					<xsl:if test="cbc:TaxTypeCode='0015' ">
						<xsl:text> </xsl:text>
						<xsl:if test="../../cbc:Percent">
							<xsl:text> %</xsl:text>
							<xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:for-each
					select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
					<xsl:if test="cbc:TaxTypeCode='0015' ">
						<xsl:text> </xsl:text>
						<xsl:for-each select="../../cbc:TaxAmount">
							<xsl:call-template name="Curr_Type"/>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
				<xsl:for-each select="cbc:LineExtensionAmount">
					<xsl:call-template name="Curr_Type"/>
				</xsl:for-each>
			</td>
			<xsl:if test="//n1:Invoice/cbc:ProfileID='IHRACAT'">
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:DeliveryTerms/cbc:ID[@schemeID='INCOTERMS']">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:PackagingTypeCode">
						<xsl:text>&#160;</xsl:text>
						<xsl:call-template name="Packaging">
							<xsl:with-param name="PackagingType">
								<xsl:value-of select="."/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:ID">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:Quantity">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:DeliveryAddress">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode">
						<xsl:text>&#160;</xsl:text>
						<xsl:call-template name="TransportMode">
							<xsl:with-param name="TransportModeType">
								<xsl:value-of select="."/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:GoodsItem/cbc:RequiredCustomsID">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>				
			</xsl:if>			
		</tr>
	</xsl:template>
	<xsl:template match="//cbc:IssueDate">
		<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
	</xsl:template>
	<xsl:template match="//n1:Invoice">
		<tr class="lineTableTr">
			<td class="lineTableTd">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#160;</xsl:text>
			</td>
			<xsl:if test="//n1:Invoice/cbc:ProfileID='IHRACAT'">
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
				</td>
			</xsl:if>			
		</tr>
	</xsl:template>
	<xsl:template name="Party_Title" >
		<xsl:param name="PartyType" />
		<td style="width:469px; " align="left">
			<xsl:if test="cac:PartyName">
				<xsl:value-of select="cac:PartyName/cbc:Name"/>
				<br/>
			</xsl:if>
			<xsl:for-each select="cac:Person">
				<xsl:for-each select="cbc:Title">
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:FirstName">
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:MiddleName">
					<xsl:apply-templates/>
					<xsl:text>&#160; </xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:FamilyName">
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:NameSuffix">
					<xsl:apply-templates/>
				</xsl:for-each>
				<xsl:if test="$PartyType='TAXFREE'">
					<br/>
					<xsl:text>Pasaport No: </xsl:text>
					<xsl:value-of select="cac:IdentityDocumentReference/cbc:ID"/>
					<br/>
					<xsl:text>Ülkesi: </xsl:text>
					<xsl:for-each select="cbc:NationalityID">
						<xsl:call-template name="Country">
							<xsl:with-param name="CountryType"><xsl:value-of select="."/></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</td>		
	</xsl:template>
	<xsl:template name="Party_Adress" >
		<xsl:param name="PartyType" />
		<td style="width:469px; " align="left">
			<xsl:for-each select="cac:PostalAddress">
				<xsl:for-each select="cbc:StreetName">
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:BuildingName">
					<xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="cbc:BuildingNumber">
					<xsl:text> No:</xsl:text>
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<br/>
				<xsl:for-each select="cbc:Room">
					<xsl:text>Kapı No:</xsl:text>
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<br/>
				<xsl:for-each select="cbc:PostalZone">
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:CitySubdivisionName">
					<xsl:apply-templates/>
					<xsl:text>/ </xsl:text>
				</xsl:for-each>
				<xsl:for-each select="cbc:CityName">
					<xsl:apply-templates/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:if test="$PartyType!='OTHER'">
					<br/>
					<xsl:value-of select="cac:Country/cbc:Name"/>
					<br/>
				</xsl:if>
			</xsl:for-each>
		</td>
	</xsl:template>
	<xsl:template name="TransportMode">
		<xsl:param name="TransportModeType" />
		<xsl:choose>
			<xsl:when test="$TransportModeType=1">Denizyolu</xsl:when>
			<xsl:when test="$TransportModeType=2">Demiryolu</xsl:when>
			<xsl:when test="$TransportModeType=3">Karayolu</xsl:when>
			<xsl:when test="$TransportModeType=4">Havayolu</xsl:when>
			<xsl:when test="$TransportModeType=5">Posta</xsl:when>
			<xsl:when test="$TransportModeType=6">Çok araçlı</xsl:when>
			<xsl:when test="$TransportModeType=7">Sabit taşıma tesisleri</xsl:when>
			<xsl:when test="$TransportModeType=8">İç su taşımacılığı</xsl:when>			
			<xsl:otherwise><xsl:value-of select="$TransportModeType"/></xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	<xsl:template name="Packaging">
		<xsl:param name="PackagingType" />
		<xsl:choose>
			<xsl:when test="$PackagingType='1A'">Drum, steel</xsl:when>
			<xsl:when test="$PackagingType='1B'">Drum, aluminium</xsl:when>
			<xsl:when test="$PackagingType='1D'">Drum, plywood</xsl:when>
			<xsl:when test="$PackagingType='1F'">Container, flexible</xsl:when>
			<xsl:when test="$PackagingType='1G'">Drum, fibre</xsl:when>
			<xsl:when test="$PackagingType='1W'">Drum, wooden</xsl:when>
			<xsl:when test="$PackagingType='2C'">Barrel, wooden</xsl:when>
			<xsl:when test="$PackagingType='3A'">Jerrican, steel</xsl:when>
			<xsl:when test="$PackagingType='3H'">Jerrican, plastic</xsl:when>
			<xsl:when test="$PackagingType='43'">Bag, super bulk</xsl:when>
			<xsl:when test="$PackagingType='44'">Bag, polybag</xsl:when>
			<xsl:when test="$PackagingType='4A'">Box, steel</xsl:when>
			<xsl:when test="$PackagingType='4B'">Box, aluminium</xsl:when>
			<xsl:when test="$PackagingType='4C'">Box, natural wood</xsl:when>
			<xsl:when test="$PackagingType='4D'">Box, plywood</xsl:when>
			<xsl:when test="$PackagingType='4F'">Box, reconstituted wood</xsl:when>
			<xsl:when test="$PackagingType='4G'">Box, fibreboard</xsl:when>
			<xsl:when test="$PackagingType='4H'">Box, plastic</xsl:when>
			<xsl:when test="$PackagingType='5H'">Bag, woven plastic</xsl:when>
			<xsl:when test="$PackagingType='5L'">Bag, textile</xsl:when>
			<xsl:when test="$PackagingType='5M'">Bag, paper</xsl:when>
			<xsl:when test="$PackagingType='6H'">Composite packaging, plastic receptacle</xsl:when>
			<xsl:when test="$PackagingType='6P'">Composite packaging, glass receptacle</xsl:when>
			<xsl:when test="$PackagingType='7A'">Case, car</xsl:when>
			<xsl:when test="$PackagingType='7B'">Case, wooden</xsl:when>
			<xsl:when test="$PackagingType='8A'">Pallet, wooden</xsl:when>
			<xsl:when test="$PackagingType='8B'">Crate, wooden</xsl:when>
			<xsl:when test="$PackagingType='8C'">Bundle, wooden</xsl:when>
			<xsl:when test="$PackagingType='AA'">Intermediate bulk container, rigid plastic</xsl:when>
			<xsl:when test="$PackagingType='AB'">Receptacle, fibre</xsl:when>
			<xsl:when test="$PackagingType='AC'">Receptacle, paper</xsl:when>
			<xsl:when test="$PackagingType='AD'">Receptacle, wooden</xsl:when>
			<xsl:when test="$PackagingType='AE'">Aerosol</xsl:when>
			<xsl:when test="$PackagingType='AF'">Pallet, modular, collars 80cms * 60cms</xsl:when>
			<xsl:when test="$PackagingType='AG'">Pallet, shrinkwrapped</xsl:when>
			<xsl:when test="$PackagingType='AH'">Pallet, 100cms * 110cms</xsl:when>
			<xsl:when test="$PackagingType='AI'">Clamshell</xsl:when>
			<xsl:when test="$PackagingType='AJ'">Cone</xsl:when>
			<xsl:when test="$PackagingType='AL'">Ball</xsl:when>
			<xsl:when test="$PackagingType='AM'">Ampoule, non-protected</xsl:when>
			<xsl:when test="$PackagingType='AP'">Ampoule, protected</xsl:when>
			<xsl:when test="$PackagingType='AT'">Atomizer</xsl:when>
			<xsl:when test="$PackagingType='AV'">Capsule</xsl:when>
			<xsl:when test="$PackagingType='B4'">Belt</xsl:when>
			<xsl:when test="$PackagingType='BA'">Barrel</xsl:when>
			<xsl:when test="$PackagingType='BB'">Bobbin</xsl:when>
			<xsl:when test="$PackagingType='BC'">Bottlecrate / bottlerack</xsl:when>
			<xsl:when test="$PackagingType='BD'">Board</xsl:when>
			<xsl:when test="$PackagingType='BE'">Bundle</xsl:when>
			<xsl:when test="$PackagingType='BF'">Balloon, non-protected</xsl:when>
			<xsl:when test="$PackagingType='BG'">Bag</xsl:when>
			<xsl:when test="$PackagingType='BH'">Bunch</xsl:when>
			<xsl:when test="$PackagingType='BI'">Bin</xsl:when>
			<xsl:when test="$PackagingType='BJ'">Bucket</xsl:when>
			<xsl:when test="$PackagingType='BK'">Basket</xsl:when>
			<xsl:when test="$PackagingType='BL'">Bale, compressed</xsl:when>
			<xsl:when test="$PackagingType='BM'">Basin</xsl:when>
			<xsl:when test="$PackagingType='BN'">Bale, non-compressed</xsl:when>
			<xsl:when test="$PackagingType='BO'">Bottle, non-protected, cylindrical</xsl:when>
			<xsl:when test="$PackagingType='BP'">Balloon, protected</xsl:when>
			<xsl:when test="$PackagingType='BQ'">Bottle, protected cylindrical</xsl:when>
			<xsl:when test="$PackagingType='BR'">Bar</xsl:when>
			<xsl:when test="$PackagingType='BS'">Bottle, non-protected, bulbous</xsl:when>
			<xsl:when test="$PackagingType='BT'">Bolt</xsl:when>
			<xsl:when test="$PackagingType='BU'">Butt</xsl:when>
			<xsl:when test="$PackagingType='BV'">Bottle, protected bulbous</xsl:when>
			<xsl:when test="$PackagingType='BW'">Box, for liquids</xsl:when>
			<xsl:when test="$PackagingType='BX'">Box</xsl:when>
			<xsl:when test="$PackagingType='BY'">Board, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='BZ'">Bars, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='CA'">Can, rectangular</xsl:when>
			<xsl:when test="$PackagingType='CB'">Crate, beer</xsl:when>
			<xsl:when test="$PackagingType='CC'">Churn</xsl:when>
			<xsl:when test="$PackagingType='CD'">Can, with handle and spout</xsl:when>
			<xsl:when test="$PackagingType='CE'">Creel</xsl:when>
			<xsl:when test="$PackagingType='CF'">Coffer</xsl:when>
			<xsl:when test="$PackagingType='CG'">Cage</xsl:when>
			<xsl:when test="$PackagingType='CH'">Chest</xsl:when>
			<xsl:when test="$PackagingType='CI'">Canister</xsl:when>
			<xsl:when test="$PackagingType='CJ'">Coffin</xsl:when>
			<xsl:when test="$PackagingType='CK'">Cask</xsl:when>
			<xsl:when test="$PackagingType='CL'">Coil</xsl:when>
			<xsl:when test="$PackagingType='CM'">Card</xsl:when>
			<xsl:when test="$PackagingType='CN'">Container, not otherwise specified as transport equipment</xsl:when>
			<xsl:when test="$PackagingType='CO'">Carboy, non-protected</xsl:when>
			<xsl:when test="$PackagingType='CP'">Carboy, protected</xsl:when>
			<xsl:when test="$PackagingType='CQ'">Cartridge</xsl:when>
			<xsl:when test="$PackagingType='CR'">Crate</xsl:when>
			<xsl:when test="$PackagingType='CS'">Case</xsl:when>
			<xsl:when test="$PackagingType='CT'">Carton</xsl:when>
			<xsl:when test="$PackagingType='CU'">Cup</xsl:when>
			<xsl:when test="$PackagingType='CV'">Cover</xsl:when>
			<xsl:when test="$PackagingType='CW'">Cage, roll</xsl:when>
			<xsl:when test="$PackagingType='CX'">Can, cylindrical</xsl:when>
			<xsl:when test="$PackagingType='CY'">Cylinder</xsl:when>
			<xsl:when test="$PackagingType='CZ'">Canvas</xsl:when>
			<xsl:when test="$PackagingType='DA'">Crate, multiple layer, plastic</xsl:when>
			<xsl:when test="$PackagingType='DB'">Crate, multiple layer, wooden</xsl:when>
			<xsl:when test="$PackagingType='DC'">Crate, multiple layer, cardboard</xsl:when>
			<xsl:when test="$PackagingType='DG'">Cage, Commonwealth Handling Equipment Pool (CHEP)</xsl:when>
			<xsl:when test="$PackagingType='DH'">Box, Commonwealth Handling Equipment Pool (CHEP), Eurobox</xsl:when>
			<xsl:when test="$PackagingType='DI'">Drum, iron</xsl:when>
			<xsl:when test="$PackagingType='DJ'">Demijohn, non-protected</xsl:when>
			<xsl:when test="$PackagingType='DK'">Crate, bulk, cardboard</xsl:when>
			<xsl:when test="$PackagingType='DL'">Crate, bulk, plastic</xsl:when>
			<xsl:when test="$PackagingType='DM'">Crate, bulk, wooden</xsl:when>
			<xsl:when test="$PackagingType='DN'">Dispenser</xsl:when>
			<xsl:when test="$PackagingType='DP'">Demijohn, protected</xsl:when>
			<xsl:when test="$PackagingType='DR'">Drum</xsl:when>
			<xsl:when test="$PackagingType='DS'">Tray, one layer no cover, plastic</xsl:when>
			<xsl:when test="$PackagingType='DT'">Tray, one layer no cover, wooden</xsl:when>
			<xsl:when test="$PackagingType='DU'">Tray, one layer no cover, polystyrene</xsl:when>
			<xsl:when test="$PackagingType='DV'">Tray, one layer no cover, cardboard</xsl:when>
			<xsl:when test="$PackagingType='DW'">Tray, two layers no cover, plastic tray</xsl:when>
			<xsl:when test="$PackagingType='DX'">Tray, two layers no cover, wooden</xsl:when>
			<xsl:when test="$PackagingType='DY'">Tray, two layers no cover, cardboard</xsl:when>
			<xsl:when test="$PackagingType='EC'">Bag, plastic</xsl:when>
			<xsl:when test="$PackagingType='ED'">Case, with pallet base</xsl:when>
			<xsl:when test="$PackagingType='EE'">Case, with pallet base, wooden</xsl:when>
			<xsl:when test="$PackagingType='EF'">Case, with pallet base, cardboard</xsl:when>
			<xsl:when test="$PackagingType='EG'">Case, with pallet base, plastic</xsl:when>
			<xsl:when test="$PackagingType='EH'">Case, with pallet base, metal</xsl:when>
			<xsl:when test="$PackagingType='EI'">Case, isothermic</xsl:when>
			<xsl:when test="$PackagingType='EN'">Envelope</xsl:when>
			<xsl:when test="$PackagingType='FB'">Flexibag</xsl:when>
			<xsl:when test="$PackagingType='FC'">Crate, fruit</xsl:when>
			<xsl:when test="$PackagingType='FD'">Crate, framed</xsl:when>
			<xsl:when test="$PackagingType='FE'">Flexitank</xsl:when>
			<xsl:when test="$PackagingType='FI'">Firkin</xsl:when>
			<xsl:when test="$PackagingType='FL'">Flask</xsl:when>
			<xsl:when test="$PackagingType='FO'">Footlocker</xsl:when>
			<xsl:when test="$PackagingType='FP'">Filmpack</xsl:when>
			<xsl:when test="$PackagingType='FR'">Frame</xsl:when>
			<xsl:when test="$PackagingType='FT'">Foodtainer</xsl:when>
			<xsl:when test="$PackagingType='FW'">Cart, flatbed</xsl:when>
			<xsl:when test="$PackagingType='FX'">Bag, flexible container</xsl:when>
			<xsl:when test="$PackagingType='GB'">Bottle, gas</xsl:when>
			<xsl:when test="$PackagingType='GI'">Girder</xsl:when>
			<xsl:when test="$PackagingType='GL'">Container, gallon</xsl:when>
			<xsl:when test="$PackagingType='GR'">Receptacle, glass</xsl:when>
			<xsl:when test="$PackagingType='GU'">Tray, containing horizontally stacked flat items</xsl:when>
			<xsl:when test="$PackagingType='GY'">Bag, gunny</xsl:when>
			<xsl:when test="$PackagingType='GZ'">Girders, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='HA'">Basket, with handle, plastic</xsl:when>
			<xsl:when test="$PackagingType='HB'">Basket, with handle, wooden</xsl:when>
			<xsl:when test="$PackagingType='HC'">Basket, with handle, cardboard</xsl:when>
			<xsl:when test="$PackagingType='HG'">Hogshead</xsl:when>
			<xsl:when test="$PackagingType='HN'">Hanger</xsl:when>
			<xsl:when test="$PackagingType='HR'">Hamper</xsl:when>
			<xsl:when test="$PackagingType='IA'">Package, display, wooden</xsl:when>
			<xsl:when test="$PackagingType='IB'">Package, display, cardboard</xsl:when>
			<xsl:when test="$PackagingType='IC'">Package, display, plastic</xsl:when>
			<xsl:when test="$PackagingType='ID'">Package, display, metal</xsl:when>
			<xsl:when test="$PackagingType='IE'">Package, show</xsl:when>
			<xsl:when test="$PackagingType='IF'">Package, flow</xsl:when>
			<xsl:when test="$PackagingType='IG'">Package, paper wrapped</xsl:when>
			<xsl:when test="$PackagingType='IH'">Drum, plastic</xsl:when>
			<xsl:when test="$PackagingType='IK'">Package, cardboard, with bottle grip-holes</xsl:when>
			<xsl:when test="$PackagingType='IL'">Tray, rigid, lidded stackable (CEN TS 14482:2002)</xsl:when>
			<xsl:when test="$PackagingType='IN'">Ingot</xsl:when>
			<xsl:when test="$PackagingType='IZ'">Ingots, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='JB'">Bag, jumbo</xsl:when>
			<xsl:when test="$PackagingType='JC'">Jerrican, rectangular</xsl:when>
			<xsl:when test="$PackagingType='JG'">Jug</xsl:when>
			<xsl:when test="$PackagingType='JR'">Jar</xsl:when>
			<xsl:when test="$PackagingType='JT'">Jutebag</xsl:when>
			<xsl:when test="$PackagingType='JY'">Jerrican, cylindrical</xsl:when>
			<xsl:when test="$PackagingType='KG'">Keg</xsl:when>
			<xsl:when test="$PackagingType='KI'">Kit</xsl:when>
			<xsl:when test="$PackagingType='LE'">Luggage</xsl:when>
			<xsl:when test="$PackagingType='LG'">Log</xsl:when>
			<xsl:when test="$PackagingType='LT'">Lot</xsl:when>
			<xsl:when test="$PackagingType='LU'">Lug</xsl:when>
			<xsl:when test="$PackagingType='LV'">Liftvan</xsl:when>
			<xsl:when test="$PackagingType='LZ'">Logs, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='MA'">Crate, metal</xsl:when>
			<xsl:when test="$PackagingType='MB'">Bag, multiply</xsl:when>
			<xsl:when test="$PackagingType='MC'">Crate, milk</xsl:when>
			<xsl:when test="$PackagingType='ME'">Container, metal</xsl:when>
			<xsl:when test="$PackagingType='MR'">Receptacle, metal</xsl:when>
			<xsl:when test="$PackagingType='MS'">Sack, multi-wall</xsl:when>
			<xsl:when test="$PackagingType='MT'">Mat</xsl:when>
			<xsl:when test="$PackagingType='MW'">Receptacle, plastic wrapped</xsl:when>
			<xsl:when test="$PackagingType='MX'">Matchbox</xsl:when>
			<xsl:when test="$PackagingType='NA'">Not available</xsl:when>
			<xsl:when test="$PackagingType='NE'">Unpacked or unpackaged</xsl:when>
			<xsl:when test="$PackagingType='NF'">Unpacked or unpackaged, single unit</xsl:when>
			<xsl:when test="$PackagingType='NG'">Unpacked or unpackaged, multiple units</xsl:when>
			<xsl:when test="$PackagingType='NS'">Nest</xsl:when>
			<xsl:when test="$PackagingType='NT'">Net</xsl:when>
			<xsl:when test="$PackagingType='NU'">Net, tube, plastic</xsl:when>
			<xsl:when test="$PackagingType='NV'">Net, tube, textile</xsl:when>
			<xsl:when test="$PackagingType='OA'">Pallet, CHEP 40 cm x 60 cm</xsl:when>
			<xsl:when test="$PackagingType='OB'">Pallet, CHEP 80 cm x 120 cm</xsl:when>
			<xsl:when test="$PackagingType='OC'">Pallet, CHEP 100 cm x 120 cm</xsl:when>
			<xsl:when test="$PackagingType='OD'">Pallet, AS 4068-1993</xsl:when>
			<xsl:when test="$PackagingType='OE'">Pallet, ISO T11</xsl:when>
			<xsl:when test="$PackagingType='OF'">Platform, unspecified weight or dimension</xsl:when>
			<xsl:when test="$PackagingType='OK'">Block</xsl:when>
			<xsl:when test="$PackagingType='OT'">Octabin</xsl:when>
			<xsl:when test="$PackagingType='OU'">Container, outer</xsl:when>
			<xsl:when test="$PackagingType='P2'">Pan</xsl:when>
			<xsl:when test="$PackagingType='PA'">Packet</xsl:when>
			<xsl:when test="$PackagingType='PB'">Pallet, box Combined open-ended box and pallet</xsl:when>
			<xsl:when test="$PackagingType='PC'">Parcel</xsl:when>
			<xsl:when test="$PackagingType='PD'">Pallet, modular, collars 80cms * 100cms</xsl:when>
			<xsl:when test="$PackagingType='PE'">Pallet, modular, collars 80cms * 120cms</xsl:when>
			<xsl:when test="$PackagingType='PF'">Pen</xsl:when>
			<xsl:when test="$PackagingType='PG'">Plate</xsl:when>
			<xsl:when test="$PackagingType='PH'">Pitcher</xsl:when>
			<xsl:when test="$PackagingType='PI'">Pipe</xsl:when>
			<xsl:when test="$PackagingType='PJ'">Punnet</xsl:when>
			<xsl:when test="$PackagingType='PK'">Package</xsl:when>
			<xsl:when test="$PackagingType='PL'">Pail</xsl:when>
			<xsl:when test="$PackagingType='PN'">Plank</xsl:when>
			<xsl:when test="$PackagingType='PO'">Pouch</xsl:when>
			<xsl:when test="$PackagingType='PP'">Piece</xsl:when>
			<xsl:when test="$PackagingType='PR'">Receptacle, plastic</xsl:when>
			<xsl:when test="$PackagingType='PT'">Pot</xsl:when>
			<xsl:when test="$PackagingType='PU'">Tray</xsl:when>
			<xsl:when test="$PackagingType='PV'">Pipes, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='PX'">Pallet</xsl:when>
			<xsl:when test="$PackagingType='PY'">Plates, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='PZ'">Planks, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='QA'">Drum, steel, non-removable head</xsl:when>
			<xsl:when test="$PackagingType='QB'">Drum, steel, removable head</xsl:when>
			<xsl:when test="$PackagingType='QC'">Drum, aluminium, non-removable head</xsl:when>
			<xsl:when test="$PackagingType='QD'">Drum, aluminium, removable head</xsl:when>
			<xsl:when test="$PackagingType='QF'">Drum, plastic, non-removable head</xsl:when>
			<xsl:when test="$PackagingType='QG'">Drum, plastic, removable head</xsl:when>
			<xsl:when test="$PackagingType='QH'">Barrel, wooden, bung type</xsl:when>
			<xsl:when test="$PackagingType='QJ'">Barrel, wooden, removable head</xsl:when>
			<xsl:when test="$PackagingType='QK'">Jerrican, steel, non-removable head</xsl:when>
			<xsl:when test="$PackagingType='QL'">Jerrican, steel, removable head</xsl:when>
			<xsl:when test="$PackagingType='QM'">Jerrican, plastic, non-removable head</xsl:when>
			<xsl:when test="$PackagingType='QN'">Jerrican, plastic, removable head</xsl:when>
			<xsl:when test="$PackagingType='QP'">Box, wooden, natural wood, ordinary</xsl:when>
			<xsl:when test="$PackagingType='QQ'">Box, wooden, natural wood, with sift proof walls</xsl:when>
			<xsl:when test="$PackagingType='QR'">Box, plastic, expanded</xsl:when>
			<xsl:when test="$PackagingType='QS'">Box, plastic, solid</xsl:when>
			<xsl:when test="$PackagingType='RD'">Rod</xsl:when>
			<xsl:when test="$PackagingType='RG'">Ring</xsl:when>
			<xsl:when test="$PackagingType='RJ'">Rack, clothing hanger</xsl:when>
			<xsl:when test="$PackagingType='RK'">Rack</xsl:when>
			<xsl:when test="$PackagingType='RL'">Reel</xsl:when>
			<xsl:when test="$PackagingType='RO'">Roll</xsl:when>
			<xsl:when test="$PackagingType='RT'">Rednet</xsl:when>
			<xsl:when test="$PackagingType='RZ'">Rods, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='SA'">Sack</xsl:when>
			<xsl:when test="$PackagingType='SB'">Slab</xsl:when>
			<xsl:when test="$PackagingType='SC'">Crate, shallow</xsl:when>
			<xsl:when test="$PackagingType='SD'">Spindle</xsl:when>
			<xsl:when test="$PackagingType='SE'">Sea-chest</xsl:when>
			<xsl:when test="$PackagingType='SH'">Sachet</xsl:when>
			<xsl:when test="$PackagingType='SI'">Skid</xsl:when>
			<xsl:when test="$PackagingType='SK'">Case, skeleton</xsl:when>
			<xsl:when test="$PackagingType='SL'">Slipsheet</xsl:when>
			<xsl:when test="$PackagingType='SM'">Sheetmetal</xsl:when>
			<xsl:when test="$PackagingType='SO'">Spool</xsl:when>
			<xsl:when test="$PackagingType='SP'">Sheet, plastic wrapping</xsl:when>
			<xsl:when test="$PackagingType='SS'">Case, steel</xsl:when>
			<xsl:when test="$PackagingType='ST'">Sheet</xsl:when>
			<xsl:when test="$PackagingType='SU'">Suitcase</xsl:when>
			<xsl:when test="$PackagingType='SV'">Envelope, steel</xsl:when>
			<xsl:when test="$PackagingType='SW'">Shrinkwrapped</xsl:when>
			<xsl:when test="$PackagingType='SX'">Set</xsl:when>
			<xsl:when test="$PackagingType='SY'">Sleeve</xsl:when>
			<xsl:when test="$PackagingType='SZ'">Sheets, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='T1'">Tablet</xsl:when>
			<xsl:when test="$PackagingType='TB'">Tub</xsl:when>
			<xsl:when test="$PackagingType='TC'">Tea-chest</xsl:when>
			<xsl:when test="$PackagingType='TD'">Tube, collapsible</xsl:when>
			<xsl:when test="$PackagingType='TE'">Tyre</xsl:when>
			<xsl:when test="$PackagingType='TG'">Tank container, generic</xsl:when>
			<xsl:when test="$PackagingType='TI'">Tierce</xsl:when>
			<xsl:when test="$PackagingType='TK'">Tank, rectangular</xsl:when>
			<xsl:when test="$PackagingType='TL'">Tub, with lid</xsl:when>
			<xsl:when test="$PackagingType='TN'">Tin</xsl:when>
			<xsl:when test="$PackagingType='TO'">Tun</xsl:when>
			<xsl:when test="$PackagingType='TR'">Trunk</xsl:when>
			<xsl:when test="$PackagingType='TS'">Truss</xsl:when>
			<xsl:when test="$PackagingType='TT'">Bag, tote</xsl:when>
			<xsl:when test="$PackagingType='TU'">Tube</xsl:when>
			<xsl:when test="$PackagingType='TV'">Tube, with nozzle</xsl:when>
			<xsl:when test="$PackagingType='TW'">Pallet, triwall</xsl:when>
			<xsl:when test="$PackagingType='TY'">Tank, cylindrical</xsl:when>
			<xsl:when test="$PackagingType='TZ'">Tubes, in bundle/bunch/truss</xsl:when>
			<xsl:when test="$PackagingType='UC'">Uncaged</xsl:when>
			<xsl:when test="$PackagingType='UN'">Unit</xsl:when>
			<xsl:when test="$PackagingType='VA'">Vat</xsl:when>
			<xsl:when test="$PackagingType='VG'">Bulk, gas (at 1031 mbar and 15Â°C)</xsl:when>
			<xsl:when test="$PackagingType='VI'">Vial</xsl:when>
			<xsl:when test="$PackagingType='VK'">Vanpack</xsl:when>
			<xsl:when test="$PackagingType='VL'">Bulk, liquid</xsl:when>
			<xsl:when test="$PackagingType='VO'">Bulk, solid, large particles (Â“nodulesÂ”)</xsl:when>
			<xsl:when test="$PackagingType='VP'">Vacuum-packed</xsl:when>
			<xsl:when test="$PackagingType='VQ'">Bulk, liquefied gas (at abnormal temperature/pressure)</xsl:when>
			<xsl:when test="$PackagingType='VN'">Vehicle</xsl:when>
			<xsl:when test="$PackagingType='VR'">Bulk, solid, granular particles (Â“grainsÂ”)</xsl:when>
			<xsl:when test="$PackagingType='VS'">Bulk, scrap metal</xsl:when>
			<xsl:when test="$PackagingType='VY'">Bulk, solid, fine particles (Â“powdersÂ”)</xsl:when>
			<xsl:when test="$PackagingType='WA'">Intermediate bulk container</xsl:when>
			<xsl:when test="$PackagingType='WB'">Wickerbottle</xsl:when>
			<xsl:when test="$PackagingType='WC'">Intermediate bulk container, steel</xsl:when>
			<xsl:when test="$PackagingType='WD'">Intermediate bulk container, aluminium</xsl:when>
			<xsl:when test="$PackagingType='WF'">Intermediate bulk container, metal</xsl:when>
			<xsl:when test="$PackagingType='WG'">Intermediate bulk container, steel, pressurised > 10 kpa</xsl:when>
			<xsl:when test="$PackagingType='WH'">Intermediate bulk container, aluminium, pressurised > 10 kpa</xsl:when>
			<xsl:when test="$PackagingType='WJ'">Intermediate bulk container, metal, pressure 10 kpa</xsl:when>
			<xsl:when test="$PackagingType='WK'">Intermediate bulk container, steel, liquid</xsl:when>
			<xsl:when test="$PackagingType='WL'">Intermediate bulk container, aluminium, liquid</xsl:when>
			<xsl:when test="$PackagingType='WM'">Intermediate bulk container, metal, liquid</xsl:when>
			<xsl:when test="$PackagingType='WN'">Intermediate bulk container, woven plastic, without coat/liner</xsl:when>
			<xsl:when test="$PackagingType='WP'">Intermediate bulk container, woven plastic, coated</xsl:when>
			<xsl:when test="$PackagingType='WQ'">Intermediate bulk container, woven plastic, with liner</xsl:when>
			<xsl:when test="$PackagingType='WR'">Intermediate bulk container, woven plastic, coated and liner</xsl:when>
			<xsl:when test="$PackagingType='WS'">Intermediate bulk container, plastic film</xsl:when>
			<xsl:when test="$PackagingType='WT'">Intermediate bulk container, textile with out coat/liner</xsl:when>
			<xsl:when test="$PackagingType='WU'">Intermediate bulk container, natural wood, with inner liner</xsl:when>
			<xsl:when test="$PackagingType='WV'">Intermediate bulk container, textile, coated</xsl:when>
			<xsl:when test="$PackagingType='WW'">Intermediate bulk container, textile, with liner</xsl:when>
			<xsl:when test="$PackagingType='WX'">Intermediate bulk container, textile, coated and liner</xsl:when>
			<xsl:when test="$PackagingType='WY'">Intermediate bulk container, plywood, with inner liner</xsl:when>
			<xsl:when test="$PackagingType='WZ'">Intermediate bulk container, reconstituted wood, with inner liner</xsl:when>
			<xsl:when test="$PackagingType='XA'">Bag, woven plastic, without inner coat/liner</xsl:when>
			<xsl:when test="$PackagingType='XB'">Bag, woven plastic, sift proof</xsl:when>
			<xsl:when test="$PackagingType='XC'">Bag, woven plastic, water resistant</xsl:when>
			<xsl:when test="$PackagingType='XD'">Bag, plastics film</xsl:when>
			<xsl:when test="$PackagingType='XF'">Bag, textile, without inner coat/liner</xsl:when>
			<xsl:when test="$PackagingType='XG'">Bag, textile, sift proof</xsl:when>
			<xsl:when test="$PackagingType='XH'">Bag, textile, water resistant</xsl:when>
			<xsl:when test="$PackagingType='XJ'">Bag, paper, multi-wall</xsl:when>
			<xsl:when test="$PackagingType='XK'">Bag, paper, multi-wall, water resistant</xsl:when>
			<xsl:when test="$PackagingType='YA'">Composite packaging, plastic receptacle in steel drum</xsl:when>
			<xsl:when test="$PackagingType='YB'">Composite packaging, plastic receptacle in steel crate box</xsl:when>
			<xsl:when test="$PackagingType='YC'">Composite packaging, plastic receptacle in aluminium drum</xsl:when>
			<xsl:when test="$PackagingType='YD'">Composite packaging, plastic receptacle in aluminium crate</xsl:when>
			<xsl:when test="$PackagingType='YF'">Composite packaging, plastic receptacle in wooden box</xsl:when>
			<xsl:when test="$PackagingType='YG'">Composite packaging, plastic receptacle in plywood drum</xsl:when>
			<xsl:when test="$PackagingType='YH'">Composite packaging, plastic receptacle in plywood box</xsl:when>
			<xsl:when test="$PackagingType='YJ'">Composite packaging, plastic receptacle in fibre drum</xsl:when>
			<xsl:when test="$PackagingType='YK'">Composite packaging, plastic receptacle in fibreboard box</xsl:when>
			<xsl:when test="$PackagingType='YL'">Composite packaging, plastic receptacle in plastic drum</xsl:when>
			<xsl:when test="$PackagingType='YM'">Composite packaging, plastic receptacle in solid plastic box</xsl:when>
			<xsl:when test="$PackagingType='YN'">Composite packaging, glass receptacle in steel drum</xsl:when>
			<xsl:when test="$PackagingType='YP'">Composite packaging, glass receptacle in steel crate box</xsl:when>
			<xsl:when test="$PackagingType='YQ'">Composite packaging, glass receptacle in aluminium drum</xsl:when>
			<xsl:when test="$PackagingType='YR'">Composite packaging, glass receptacle in aluminium crate</xsl:when>
			<xsl:when test="$PackagingType='YS'">Composite packaging, glass receptacle in wooden box</xsl:when>
			<xsl:when test="$PackagingType='YT'">Composite packaging, glass receptacle in plywood drum</xsl:when>
			<xsl:when test="$PackagingType='YV'">Composite packaging, glass receptacle in wickerwork hamper</xsl:when>
			<xsl:when test="$PackagingType='YW'">Composite packaging, glass receptacle in fibre drum</xsl:when>
			<xsl:when test="$PackagingType='YX'">Composite packaging, glass receptacle in fibreboard box</xsl:when>
			<xsl:when test="$PackagingType='YY'">Composite packaging, glass receptacle in expandable plastic pack</xsl:when>
			<xsl:when test="$PackagingType='YZ'">Composite packaging, glass receptacle in solid plastic pack</xsl:when>
			<xsl:when test="$PackagingType='ZA'">Intermediate bulk container, paper, multi-wall</xsl:when>
			<xsl:when test="$PackagingType='ZB'">Bag, large</xsl:when>
			<xsl:when test="$PackagingType='ZC'">Intermediate bulk container, paper, multi-wall, water resistant</xsl:when>
			<xsl:when test="$PackagingType='ZD'">Intermediate bulk container, rigid plastic, with structural equipment, solids</xsl:when>
			<xsl:when test="$PackagingType='ZF'">Intermediate bulk container, rigid plastic, freestanding, solids</xsl:when>
			<xsl:when test="$PackagingType='ZG'">Intermediate bulk container, rigid plastic, with structural equipment, pressurised</xsl:when>
			<xsl:when test="$PackagingType='ZH'">Intermediate bulk container, rigid plastic, freestanding, pressurised</xsl:when>
			<xsl:when test="$PackagingType='ZJ'">Intermediate bulk container, rigid plastic, with structural equipment, liquids</xsl:when>
			<xsl:when test="$PackagingType='ZK'">Intermediate bulk container, rigid plastic, freestanding, liquids</xsl:when>
			<xsl:when test="$PackagingType='ZL'">Intermediate bulk container, composite, rigid plastic, solids</xsl:when>
			<xsl:when test="$PackagingType='ZM'">Intermediate bulk container, composite, flexible plastic, solids</xsl:when>
			<xsl:when test="$PackagingType='ZN'">Intermediate bulk container, composite, rigid plastic, pressurised</xsl:when>
			<xsl:when test="$PackagingType='ZP'">Intermediate bulk container, composite, flexible plastic, pressurised</xsl:when>
			<xsl:when test="$PackagingType='ZQ'">Intermediate bulk container, composite, rigid plastic, liquids</xsl:when>
			<xsl:when test="$PackagingType='ZR'">Intermediate bulk container, composite, flexible plastic, liquids</xsl:when>
			<xsl:when test="$PackagingType='ZS'">Intermediate bulk container, composite</xsl:when>
			<xsl:when test="$PackagingType='ZT'">Intermediate bulk container, fibreboard</xsl:when>
			<xsl:when test="$PackagingType='ZU'">Intermediate bulk container, flexible</xsl:when>
			<xsl:when test="$PackagingType='ZV'">Intermediate bulk container, metal, other than steel</xsl:when>
			<xsl:when test="$PackagingType='ZW'">Intermediate bulk container, natural wood</xsl:when>
			<xsl:when test="$PackagingType='ZX'">Intermediate bulk container, plywood</xsl:when>
			<xsl:when test="$PackagingType='ZY'">Intermediate bulk container, reconstituted wood</xsl:when>
			<xsl:otherwise><xsl:value-of select="$PackagingType"/></xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	<xsl:template name="Country">
		<xsl:param name="CountryType" />
		<xsl:choose>
			<xsl:when test="$CountryType='AF'">Afganistan</xsl:when>
			<xsl:when test="$CountryType='DE'">Almanya</xsl:when>
			<xsl:when test="$CountryType='AD'">Andorra</xsl:when>
			<xsl:when test="$CountryType='AO'">Angola</xsl:when>
			<xsl:when test="$CountryType='AG'">Antigua ve Barbuda</xsl:when>
			<xsl:when test="$CountryType='AR'">Arjantin</xsl:when>
			<xsl:when test="$CountryType='AL'">Arnavutluk</xsl:when>
			<xsl:when test="$CountryType='AW'">Aruba</xsl:when>
			<xsl:when test="$CountryType='AU'">Avustralya</xsl:when>
			<xsl:when test="$CountryType='AT'">Avusturya</xsl:when>
			<xsl:when test="$CountryType='AZ'">Azerbaycan</xsl:when>
			<xsl:when test="$CountryType='BS'">Bahamalar</xsl:when>
			<xsl:when test="$CountryType='BH'">Bahreyn</xsl:when>
			<xsl:when test="$CountryType='BD'">Bangladeş</xsl:when>
			<xsl:when test="$CountryType='BB'">Barbados</xsl:when>
			<xsl:when test="$CountryType='EH'">Batı Sahra (MA)</xsl:when>
			<xsl:when test="$CountryType='BE'">Belçika</xsl:when>
			<xsl:when test="$CountryType='BZ'">Belize</xsl:when>
			<xsl:when test="$CountryType='BJ'">Benin</xsl:when>
			<xsl:when test="$CountryType='BM'">Bermuda</xsl:when>
			<xsl:when test="$CountryType='BY'">Beyaz Rusya</xsl:when>
			<xsl:when test="$CountryType='BT'">Bhutan</xsl:when>
			<xsl:when test="$CountryType='AE'">Birleşik Arap Emirlikleri</xsl:when>
			<xsl:when test="$CountryType='US'">Birleşik Devletler</xsl:when>
			<xsl:when test="$CountryType='GB'">Birleşik Krallık</xsl:when>
			<xsl:when test="$CountryType='BO'">Bolivya</xsl:when>
			<xsl:when test="$CountryType='BA'">Bosna-Hersek</xsl:when>
			<xsl:when test="$CountryType='BW'">Botsvana</xsl:when>
			<xsl:when test="$CountryType='BR'">Brezilya</xsl:when>
			<xsl:when test="$CountryType='BN'">Bruney</xsl:when>
			<xsl:when test="$CountryType='BG'">Bulgaristan</xsl:when>
			<xsl:when test="$CountryType='BF'">Burkina Faso</xsl:when>
			<xsl:when test="$CountryType='BI'">Burundi</xsl:when>
			<xsl:when test="$CountryType='TD'">Çad</xsl:when>
			<xsl:when test="$CountryType='KY'">Cayman Adaları</xsl:when>
			<xsl:when test="$CountryType='GI'">Cebelitarık (GB)</xsl:when>
			<xsl:when test="$CountryType='CZ'">Çek Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='DZ'">Cezayir</xsl:when>
			<xsl:when test="$CountryType='DJ'">Cibuti</xsl:when>
			<xsl:when test="$CountryType='CN'">Çin</xsl:when>
			<xsl:when test="$CountryType='DK'">Danimarka</xsl:when>
			<xsl:when test="$CountryType='CD'">Demokratik Kongo Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='TL'">Doğu Timor</xsl:when>
			<xsl:when test="$CountryType='DO'">Dominik Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='DM'">Dominika</xsl:when>
			<xsl:when test="$CountryType='EC'">Ekvador</xsl:when>
			<xsl:when test="$CountryType='GQ'">Ekvator Ginesi</xsl:when>
			<xsl:when test="$CountryType='SV'">El Salvador</xsl:when>
			<xsl:when test="$CountryType='ID'">Endonezya</xsl:when>
			<xsl:when test="$CountryType='ER'">Eritre</xsl:when>
			<xsl:when test="$CountryType='AM'">Ermenistan</xsl:when>
			<xsl:when test="$CountryType='MF'">Ermiş Martin (FR)</xsl:when>
			<xsl:when test="$CountryType='EE'">Estonya</xsl:when>
			<xsl:when test="$CountryType='ET'">Etiyopya</xsl:when>
			<xsl:when test="$CountryType='FK'">Falkland Adaları</xsl:when>
			<xsl:when test="$CountryType='FO'">Faroe Adaları (DK)</xsl:when>
			<xsl:when test="$CountryType='MA'">Fas</xsl:when>
			<xsl:when test="$CountryType='FJ'">Fiji</xsl:when>
			<xsl:when test="$CountryType='CI'">Fildişi Sahili</xsl:when>
			<xsl:when test="$CountryType='PH'">Filipinler</xsl:when>
			<xsl:when test="$CountryType='FI'">Finlandiya</xsl:when>
			<xsl:when test="$CountryType='FR'">Fransa</xsl:when>
			<xsl:when test="$CountryType='GF'">Fransız Guyanası (FR)</xsl:when>
			<xsl:when test="$CountryType='PF'">Fransız Polinezyası (FR)</xsl:when>
			<xsl:when test="$CountryType='GA'">Gabon</xsl:when>
			<xsl:when test="$CountryType='GM'">Gambiya</xsl:when>
			<xsl:when test="$CountryType='GH'">Gana</xsl:when>
			<xsl:when test="$CountryType='GN'">Gine</xsl:when>
			<xsl:when test="$CountryType='GW'">Gine Bissau</xsl:when>
			<xsl:when test="$CountryType='GD'">Grenada</xsl:when>
			<xsl:when test="$CountryType='GL'">Grönland (DK)</xsl:when>
			<xsl:when test="$CountryType='GP'">Guadeloupe (FR)</xsl:when>
			<xsl:when test="$CountryType='GT'">Guatemala</xsl:when>
			<xsl:when test="$CountryType='GG'">Guernsey (GB)</xsl:when>
			<xsl:when test="$CountryType='ZA'">Güney Afrika</xsl:when>
			<xsl:when test="$CountryType='KR'">Güney Kore</xsl:when>
			<xsl:when test="$CountryType='GE'">Gürcistan</xsl:when>
			<xsl:when test="$CountryType='GY'">Guyana</xsl:when>
			<xsl:when test="$CountryType='HT'">Haiti</xsl:when>
			<xsl:when test="$CountryType='IN'">Hindistan</xsl:when>
			<xsl:when test="$CountryType='HR'">Hırvatistan</xsl:when>
			<xsl:when test="$CountryType='NL'">Hollanda</xsl:when>
			<xsl:when test="$CountryType='HN'">Honduras</xsl:when>
			<xsl:when test="$CountryType='HK'">Hong Kong (CN)</xsl:when>
			<xsl:when test="$CountryType='VG'">İngiliz Virjin Adaları</xsl:when>
			<xsl:when test="$CountryType='IQ'">Irak</xsl:when>
			<xsl:when test="$CountryType='IR'">İran</xsl:when>
			<xsl:when test="$CountryType='IE'">İrlanda</xsl:when>
			<xsl:when test="$CountryType='ES'">İspanya</xsl:when>
			<xsl:when test="$CountryType='IL'">İsrail</xsl:when>
			<xsl:when test="$CountryType='SE'">İsveç</xsl:when>
			<xsl:when test="$CountryType='CH'">İsviçre</xsl:when>
			<xsl:when test="$CountryType='IT'">İtalya</xsl:when>
			<xsl:when test="$CountryType='IS'">İzlanda</xsl:when>
			<xsl:when test="$CountryType='JM'">Jamaika</xsl:when>
			<xsl:when test="$CountryType='JP'">Japonya</xsl:when>
			<xsl:when test="$CountryType='JE'">Jersey (GB)</xsl:when>
			<xsl:when test="$CountryType='KH'">Kamboçya</xsl:when>
			<xsl:when test="$CountryType='CM'">Kamerun</xsl:when>
			<xsl:when test="$CountryType='CA'">Kanada</xsl:when>
			<xsl:when test="$CountryType='ME'">Karadağ</xsl:when>
			<xsl:when test="$CountryType='QA'">Katar</xsl:when>
			<xsl:when test="$CountryType='KZ'">Kazakistan</xsl:when>
			<xsl:when test="$CountryType='KE'">Kenya</xsl:when>
			<xsl:when test="$CountryType='CY'">Kıbrıs</xsl:when>
			<xsl:when test="$CountryType='KG'">Kırgızistan</xsl:when>
			<xsl:when test="$CountryType='KI'">Kiribati</xsl:when>
			<xsl:when test="$CountryType='CO'">Kolombiya</xsl:when>
			<xsl:when test="$CountryType='KM'">Komorlar</xsl:when>
			<xsl:when test="$CountryType='CG'">Kongo Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='KV'">Kosova (RS)</xsl:when>
			<xsl:when test="$CountryType='CR'">Kosta Rika</xsl:when>
			<xsl:when test="$CountryType='CU'">Küba</xsl:when>
			<xsl:when test="$CountryType='KW'">Kuveyt</xsl:when>
			<xsl:when test="$CountryType='KP'">Kuzey Kore</xsl:when>
			<xsl:when test="$CountryType='LA'">Laos</xsl:when>
			<xsl:when test="$CountryType='LS'">Lesoto</xsl:when>
			<xsl:when test="$CountryType='LV'">Letonya</xsl:when>
			<xsl:when test="$CountryType='LR'">Liberya</xsl:when>
			<xsl:when test="$CountryType='LY'">Libya</xsl:when>
			<xsl:when test="$CountryType='LI'">Lihtenştayn</xsl:when>
			<xsl:when test="$CountryType='LT'">Litvanya</xsl:when>
			<xsl:when test="$CountryType='LB'">Lübnan</xsl:when>
			<xsl:when test="$CountryType='LU'">Lüksemburg</xsl:when>
			<xsl:when test="$CountryType='HU'">Macaristan</xsl:when>
			<xsl:when test="$CountryType='MG'">Madagaskar</xsl:when>
			<xsl:when test="$CountryType='MO'">Makao (CN)</xsl:when>
			<xsl:when test="$CountryType='MK'">Makedonya</xsl:when>
			<xsl:when test="$CountryType='MW'">Malavi</xsl:when>
			<xsl:when test="$CountryType='MV'">Maldivler</xsl:when>
			<xsl:when test="$CountryType='MY'">Malezya</xsl:when>
			<xsl:when test="$CountryType='ML'">Mali</xsl:when>
			<xsl:when test="$CountryType='MT'">Malta</xsl:when>
			<xsl:when test="$CountryType='IM'">Man Adası (GB)</xsl:when>
			<xsl:when test="$CountryType='MH'">Marshall Adaları</xsl:when>
			<xsl:when test="$CountryType='MQ'">Martinique (FR)</xsl:when>
			<xsl:when test="$CountryType='MU'">Mauritius</xsl:when>
			<xsl:when test="$CountryType='YT'">Mayotte (FR)</xsl:when>
			<xsl:when test="$CountryType='MX'">Meksika</xsl:when>
			<xsl:when test="$CountryType='FM'">Mikronezya</xsl:when>
			<xsl:when test="$CountryType='EG'">Mısır</xsl:when>
			<xsl:when test="$CountryType='MN'">Moğolistan</xsl:when>
			<xsl:when test="$CountryType='MD'">Moldova</xsl:when>
			<xsl:when test="$CountryType='MC'">Monako</xsl:when>
			<xsl:when test="$CountryType='MR'">Moritanya</xsl:when>
			<xsl:when test="$CountryType='MZ'">Mozambik</xsl:when>
			<xsl:when test="$CountryType='MM'">Myanmar</xsl:when>
			<xsl:when test="$CountryType='NA'">Namibya</xsl:when>
			<xsl:when test="$CountryType='NR'">Nauru</xsl:when>
			<xsl:when test="$CountryType='NP'">Nepal</xsl:when>
			<xsl:when test="$CountryType='NE'">Nijer</xsl:when>
			<xsl:when test="$CountryType='NG'">Nijerya</xsl:when>
			<xsl:when test="$CountryType='NI'">Nikaragua</xsl:when>
			<xsl:when test="$CountryType='NO'">Norveç</xsl:when>
			<xsl:when test="$CountryType='CF'">Orta Afrika Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='UZ'">Özbekistan</xsl:when>
			<xsl:when test="$CountryType='PK'">Pakistan</xsl:when>
			<xsl:when test="$CountryType='PW'">Palau</xsl:when>
			<xsl:when test="$CountryType='PA'">Panama</xsl:when>
			<xsl:when test="$CountryType='PG'">Papua Yeni Gine</xsl:when>
			<xsl:when test="$CountryType='PY'">Paraguay</xsl:when>
			<xsl:when test="$CountryType='PE'">Peru</xsl:when>
			<xsl:when test="$CountryType='PL'">Polonya</xsl:when>
			<xsl:when test="$CountryType='PT'">Portekiz</xsl:when>
			<xsl:when test="$CountryType='PR'">Porto Riko (US)</xsl:when>
			<xsl:when test="$CountryType='RE'">Réunion (FR)</xsl:when>
			<xsl:when test="$CountryType='RO'">Romanya</xsl:when>
			<xsl:when test="$CountryType='RW'">Ruanda</xsl:when>
			<xsl:when test="$CountryType='RU'">Rusya</xsl:when>
			<xsl:when test="$CountryType='BL'">Saint Barthélemy (FR)</xsl:when>
			<xsl:when test="$CountryType='KN'">Saint Kitts ve Nevis</xsl:when>
			<xsl:when test="$CountryType='LC'">Saint Lucia</xsl:when>
			<xsl:when test="$CountryType='PM'">Saint Pierre ve Miquelon (FR)</xsl:when>
			<xsl:when test="$CountryType='VC'">Saint Vincent ve Grenadinler</xsl:when>
			<xsl:when test="$CountryType='WS'">Samoa</xsl:when>
			<xsl:when test="$CountryType='SM'">San Marino</xsl:when>
			<xsl:when test="$CountryType='ST'">São Tomé ve Príncipe</xsl:when>
			<xsl:when test="$CountryType='SN'">Senegal</xsl:when>
			<xsl:when test="$CountryType='SC'">Seyşeller</xsl:when>
			<xsl:when test="$CountryType='SL'">Sierra Leone</xsl:when>
			<xsl:when test="$CountryType='CL'">Şili</xsl:when>
			<xsl:when test="$CountryType='SG'">Singapur</xsl:when>
			<xsl:when test="$CountryType='RS'">Sırbistan</xsl:when>
			<xsl:when test="$CountryType='SK'">Slovakya Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='SI'">Slovenya</xsl:when>
			<xsl:when test="$CountryType='SB'">Solomon Adaları</xsl:when>
			<xsl:when test="$CountryType='SO'">Somali</xsl:when>
			<xsl:when test="$CountryType='SS'">South Sudan</xsl:when>
			<xsl:when test="$CountryType='SJ'">Spitsbergen (NO)</xsl:when>
			<xsl:when test="$CountryType='LK'">Sri Lanka</xsl:when>
			<xsl:when test="$CountryType='SD'">Sudan</xsl:when>
			<xsl:when test="$CountryType='SR'">Surinam</xsl:when>
			<xsl:when test="$CountryType='SY'">Suriye</xsl:when>
			<xsl:when test="$CountryType='SA'">Suudi Arabistan</xsl:when>
			<xsl:when test="$CountryType='SZ'">Svaziland</xsl:when>
			<xsl:when test="$CountryType='TJ'">Tacikistan</xsl:when>
			<xsl:when test="$CountryType='TZ'">Tanzanya</xsl:when>
			<xsl:when test="$CountryType='TH'">Tayland</xsl:when>
			<xsl:when test="$CountryType='TW'">Tayvan</xsl:when>
			<xsl:when test="$CountryType='TG'">Togo</xsl:when>
			<xsl:when test="$CountryType='TO'">Tonga</xsl:when>
			<xsl:when test="$CountryType='TT'">Trinidad ve Tobago</xsl:when>
			<xsl:when test="$CountryType='TN'">Tunus</xsl:when>
			<xsl:when test="$CountryType='TR'">Türkiye</xsl:when>
			<xsl:when test="$CountryType='TM'">Türkmenistan</xsl:when>
			<xsl:when test="$CountryType='TC'">Turks ve Caicos</xsl:when>
			<xsl:when test="$CountryType='TV'">Tuvalu</xsl:when>
			<xsl:when test="$CountryType='UG'">Uganda</xsl:when>
			<xsl:when test="$CountryType='UA'">Ukrayna</xsl:when>
			<xsl:when test="$CountryType='OM'">Umman</xsl:when>
			<xsl:when test="$CountryType='JO'">Ürdün</xsl:when>
			<xsl:when test="$CountryType='UY'">Uruguay</xsl:when>
			<xsl:when test="$CountryType='VU'">Vanuatu</xsl:when>
			<xsl:when test="$CountryType='VA'">Vatikan</xsl:when>
			<xsl:when test="$CountryType='VE'">Venezuela</xsl:when>
			<xsl:when test="$CountryType='VN'">Vietnam</xsl:when>
			<xsl:when test="$CountryType='WF'">Wallis ve Futuna (FR)</xsl:when>
			<xsl:when test="$CountryType='YE'">Yemen</xsl:when>
			<xsl:when test="$CountryType='NC'">Yeni Kaledonya (FR)</xsl:when>
			<xsl:when test="$CountryType='NZ'">Yeni Zelanda</xsl:when>
			<xsl:when test="$CountryType='CV'">Yeşil Burun Adaları</xsl:when>
			<xsl:when test="$CountryType='GR'">Yunanistan</xsl:when>
			<xsl:when test="$CountryType='ZM'">Zambiya</xsl:when>
			<xsl:when test="$CountryType='ZW'">Zimbabve</xsl:when>
			<xsl:otherwise><xsl:value-of select="$CountryType"/></xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	<xsl:template name='Party_Other'>
		<xsl:param name="PartyType" />
		<xsl:for-each select="cbc:WebsiteURI">
			<tr align="left">
				<td>
					<xsl:text>Web Sitesi: </xsl:text>
					<xsl:value-of select="."/>
				</td>
			</tr>
		</xsl:for-each>
		<xsl:for-each select="cac:Contact/cbc:ElectronicMail">
			<tr align="left">
				<td>
					<xsl:text>E-Posta: </xsl:text>
					<xsl:value-of select="."/>
				</td>
			</tr>
		</xsl:for-each>	
		<xsl:for-each select="cac:Contact">
			<xsl:if test="cbc:Telephone or cbc:Telefax">
				<tr align="left">
					<td style="width:469px; " align="left">
						<xsl:for-each select="cbc:Telephone">
							<xsl:text>Tel: </xsl:text>
							<xsl:apply-templates/>
						</xsl:for-each>
						<xsl:for-each select="cbc:Telefax">
							<xsl:text> Fax: </xsl:text>
							<xsl:apply-templates/>
						</xsl:for-each>
						<xsl:text>&#160;</xsl:text>
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
		<xsl:if test="$PartyType!='TAXFREE' and $PartyType!='EXPORT'">
			<xsl:for-each select="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
				<tr align="left">
					<td>
						<xsl:text>Vergi Dairesi: </xsl:text>
						<xsl:apply-templates/>
					</td>
				</tr>
			</xsl:for-each>
			<xsl:for-each select="cac:PartyIdentification">
			<tr align="left">
				<td>
					<xsl:value-of select="cbc:ID/@schemeID"/>
					<xsl:text>: </xsl:text>
					<xsl:value-of select="cbc:ID"/>
				</td>
			</tr>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Curr_Type">
		<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>		
		<xsl:if	test="@currencyID">
			<xsl:text> </xsl:text>
			<xsl:choose>
				<xsl:when test="@currencyID = 'TRL' or @currencyID = 'TRY'">
					<xsl:text>TL</xsl:text>					
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@currencyID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>		
	</xsl:template>
</xsl:stylesheet>
